package newstate.tools;

import newstate.*;
import newstate.tools.*;
import javax.swing.*;
import java.awt.*;
import java.util.*;

public class FSMController extends JFrame
{
        JTextField state = new JTextField();
        JButton executeButton = new JButton("Dispatch Event");

        JList events = new JList();

        FSMContext fsmc;
        
        public FSMController(FSMContext c)
        {
                fsmc = c;
                // user interface init
                setSize(400,200);
                Container p = getContentPane();
                p.setLayout(new BorderLayout());
                p.add("North", state);
                p.add("Center", new JScrollPane(events));
                JPanel buttons = new JPanel();
                buttons.setLayout(new FlowLayout());
                buttons.add(executeButton);
                p.add("East", buttons);
                executeButton.addActionListener(new AbstractAction() {
                        public void actionPerformed(java.awt.event.ActionEvent e)
                        {
                                FSMEvent evt = (FSMEvent)events.getSelectedValue();
                                if(e!=null)
                                {
                                        fsmc.dispatch(evt, null);
                                        updateGUI();
                                }
                        }
                });
                updateGUI();
        }
        
        void updateGUI()
        {
                events.setListData(fsmc.getEvents());
                events.setSelectedIndex(0);
                state.setText("" + fsmc.getState());
        }
        
        public class LogWriter implements FSMAction
        {
                String message;
                
                public LogWriter(String s)
                {
                        setMessage(s);
                }
                
                public void execute(FSMContext fsmc, Object data)
                {
                        JTextArea log = (JTextArea)fsmc.get("log"); 
                        log.append(getMessage() + '\n');                
                }
                
                public void setMessage(String m) { message = m; }
                public String getMessage() { return message; }
        }
}